-- Recipient data provider
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'ASSESSMENT_SELECTION_VELOCITY_RCPNT', 'SQL');

-- Recipient type
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ASSESSMENT_SELECTION_VELOCITY_RCPNT');
SET @recipientTypeId=(SELECT MAX(id) FROM `msg_recipient_type`);
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) 
VALUES (@recipientTypeId+1, @dtproviderId, 'ASSESSMENT_SELECTION_VELOCITY_RCPNT');

-- New recipient query
SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ASSESSMENT_SELECTION_VELOCITY_RCPNT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT
   T6.id AS ID,
   T3.`salutationName` AS SALUTATION_NAME,
   T2.`firstName` AS FIRST_NAME,
   T2.`middleName` AS MIDDLE_NAME,
   T2.`lastName` AS LAST_NAME,
   T2.`emailId` AS EMAIL_ID,
   T2.`mobileNumber` AS MOBILE_NO,
   T2.`mobileCountryCode` AS MOBILE_CODE,
   T5.`loginId` AS LOGIN_ID,
   T15.`conditions` AS REJECTION_REMARK,
   CONVERT(FROM_BASE64(T5.passwordBase64) USING utf8) AS PASSWORD,
   CONCAT(T9.addressText,' ',T10.cityName,', ',T11.countryName,', ',T12.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
   DATE_FORMAT(T14.admissionOfferStartDate ,'%d-%m-%Y') as OFFER_LETTER_START_DATE,
   DATE_FORMAT(T14.admissionOfferEndDate ,'%d-%m-%Y') as OFFER_LETTER_END_DATE,
   'APPLICANT' AS USER_TYPE_KEY
FROM
   `application` T1 
		INNER JOIN
	`applicant_person` T2 ON T2.id = T1.applicantPersonId 
		LEFT JOIN
	`salutations` T3 ON T3.`id` = T2.`salutationId`
		LEFT JOIN
	`external_user_association` T4 ON T4.`applicationId` = T1.`id`
		LEFT JOIN
	`external_users` T5 ON T5.`id` = T4.`externalUserId`
    LEFT JOIN
    application_program T6 ON T6.applicationId = T1.id
		LEFT JOIN
    academy_location T7 ON T7.id = T6.academyLocationId		 
        LEFT JOIN
    application_condition T15 ON T15.applicationId = T1.id
        LEFT JOIN
    academy_location_addresses T8 ON T8.academyLocationId = T7.id
		LEFT OUTER JOIN
    address T9 ON T9.id = T8.addressId && T9.addressTypeId=10
		LEFT OUTER JOIN
	city T10 ON T10.id = T9.cityId
		LEFT OUTER JOIN
	country T11 ON T11.id = T10.countryId
		LEFT OUTER JOIN
	country_region T12 ON T12.id = T10.countryRegionId
		LEFT JOIN
	program_selection_process T13 on T13.programBatchSeatConfigId = T6.progBatchSeatConfigId
		LEFT JOIN
	prog_slctn_process_admisn_conf T14 on T14.programSelectionProcessId = T13.id
WHERE
   T6.id IN 
   (
      namedParams
   )",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "mobile Code",
            "resultKey": "MOBILE_CODE",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "Login Id",
            "resultKey": "LOGIN_ID",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "Password",
            "resultKey": "PASSWORD",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "Academy Location Address",
            "resultKey": "ACADEMY_LOCATION_ADDRESS",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "Offer Letter Start Date",
            "resultKey": "OFFER_LETTER_START_DATE",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "Offer Letter End Date",
            "resultKey": "OFFER_LETTER_END_DATE",
            "displayCode": "",
            "displayOrder": 12
        },       
        {
            "id": 14,
            "value": "Remarks",
            "resultKey": "REJECTION_REMARK",
            "displayCode": "",
            "displayOrder": 13
        }
    ]
}');

-- update existing DL query
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SEND_OFFER_LETTER_APPLICANT');
update sql_dtprovider set sqlquery="SELECT T1.id AS USER_ID,T1.progBatchSeatConfigId as DLS_PROGRAM_BATCH_SEAT_CONFIG_ID
FROM `application_program` T1
INNER JOIN application T2 ON T1.applicationId = T2.id
INNER JOIN `prog_batch_seat_config` T3 ON T3.id=T1.`progBatchSeatConfigId`
WHERE T1.id IN (namedParams)
<MSG@PROGRAM_CRITERIA> AND T1.programId IN (msg_scope_programIds)</MSG>
<MSG@BATCH_CRITERIA> AND T3.programBatchId IN (msg_scope_batchIds)</MSG>" where dataproviderid = @dtproviderId;

-- update recipient in message template config
SET @sysmsgevntId=(select id from system_msg_event where code='SEND_OFFER_LETTER');
SET @recipientTypeId=(SELECT id from msg_recipient_type where code = 'ASSESSMENT_SELECTION_VELOCITY_RCPNT');
UPDATE `msg_template_config` SET `recipientTypeId` = @recipientTypeId WHERE `sysMsgEventId` = @sysmsgevntId;

SET @sysmsgevntId=(select id from system_msg_event where code='SEND_OFFER_LETTER');
SET @sysevtconfId =(select id from sys_msg_evt_default_conf where systemMsgEventId=@sysmsgevntId);
SET @recipientTypeId=(SELECT id from msg_recipient_type where code = 'ASSESSMENT_SELECTION_VELOCITY_RCPNT');
UPDATE `sys_msg_evtrcpt_default_conf` SET `recipientTypeId` = @recipientTypeId WHERE `sysMsgEvtDefaultConfId` = @sysevtconfId;

SET @sysmsgevntId=(select id from system_msg_event where code='SEND_OFFER_LETTER');
SET @recipientTypeId=(SELECT id from msg_recipient_type where code = 'ASSESSMENT_SELECTION_VELOCITY_RCPNT');
UPDATE `msg_event_recepient_config` SET `recipientTypeId` = @recipientTypeId WHERE `msgTemplateCnfgId` in
(SELECT id FROM msg_template_config where sysMsgEventId = @sysmsgevntId);